# Overview

TMH Global LLC is a professional accounting and business services firm specializing in government contracting compliance and accessibility requirements. The application is built as a full-stack web platform offering services like bookkeeping, HR management, CFO services, auditing, business development, tax preparation, and specialized government contracting support including S.A.M. registration and VPAT documentation. The platform features a client portal for document management and training videos, along with comprehensive contact and consultation scheduling systems.

# User Preferences

Preferred communication style: Simple, everyday language.

# System Architecture

## Frontend Architecture
- **Framework**: React with TypeScript using Vite as the build tool
- **UI Library**: Shadcn/UI components built on Radix UI primitives for accessibility
- **Styling**: Tailwind CSS with custom design tokens and CSS variables for theming
- **Routing**: Wouter for client-side routing
- **State Management**: TanStack Query for server state management and caching
- **Forms**: React Hook Form with Zod validation for type-safe form handling

## Backend Architecture  
- **Runtime**: Node.js with Express.js REST API
- **Language**: TypeScript with ES modules
- **Development**: Hot reload with Vite middleware integration
- **File Structure**: Monorepo structure with shared types between client and server

## Data Storage
- **Database**: PostgreSQL with Drizzle ORM for type-safe database operations
- **Connection**: Neon Database serverless PostgreSQL
- **Schema Management**: Drizzle Kit for migrations and schema management
- **Storage Interface**: Abstracted storage layer with in-memory implementation for development

## Authentication and Authorization
- **Session Management**: Express sessions with PostgreSQL session store
- **File Upload**: Multer middleware for handling document uploads with file type validation
- **Security**: Input validation using Zod schemas shared between client and server

## Accessibility and Compliance Features
- **Standards**: WCAG 2.1 AA compliance built into all UI components
- **Government Requirements**: Section 508 compliance for federal contracting
- **Documentation**: VPAT (Voluntary Product Accessibility Template) support
- **Navigation**: Skip links, proper ARIA labels, and semantic HTML structure

# External Dependencies

## Core Framework Dependencies
- **@neondatabase/serverless**: Serverless PostgreSQL database connection
- **drizzle-orm**: Type-safe SQL query builder and ORM
- **@tanstack/react-query**: Server state management and data fetching
- **react-hook-form**: Form state management and validation
- **wouter**: Lightweight client-side routing

## UI and Styling
- **@radix-ui/***: Comprehensive set of accessible UI primitives
- **tailwindcss**: Utility-first CSS framework
- **class-variance-authority**: Component variant management
- **lucide-react**: Icon library

## Development and Build Tools
- **vite**: Frontend build tool and development server
- **typescript**: Type safety across the entire application
- **esbuild**: Fast JavaScript bundler for production builds
- **@replit/vite-plugin-runtime-error-modal**: Development error handling

## File Handling and Utilities
- **multer**: File upload middleware for document management
- **date-fns**: Date manipulation utilities
- **nanoid**: Unique ID generation
- **clsx**: Conditional CSS class management