import { Card, CardContent, CardHeader, CardTitle } from "@/components/ui/card";

export default function Terms() {
  return (
    <div className="py-20">
      <div className="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
        <Card>
          <CardHeader>
            <CardTitle className="text-3xl font-bold text-center">Terms of Service</CardTitle>
            <p className="text-center text-muted-foreground">Last updated: {new Date().toLocaleDateString()}</p>
          </CardHeader>
          <CardContent className="prose prose-slate max-w-none dark:prose-invert">
            <h2>Company Information</h2>
            <p>
              <strong>TMH Global LLC</strong><br />
              Professional Accounting and Business Services<br />
              Email: support@tmhglobal.com<br />
              Phone: (703) 829-7277<br />
              Website: {window.location.origin}
            </p>

            <h2>Acceptance of Terms</h2>
            <p>
              By accessing and using TMH Global LLC's services, you accept and agree to be bound by the terms and provision of this agreement.
            </p>

            <h2>Description of Services</h2>
            <p>TMH Global LLC provides professional accounting and business services including:</p>
            <ul>
              <li>Government contracting compliance and consulting</li>
              <li>Bookkeeping and financial management</li>
              <li>HR management and payroll services</li>
              <li>Tax preparation and planning</li>
              <li>Section 508 accessibility compliance</li>
              <li>SAM registration and VPAT documentation</li>
              <li>Training and educational resources</li>
            </ul>

            <h2>SMS/Text Messaging Terms</h2>
            <p>
              <strong>Service Description:</strong> TMH Global LLC offers SMS/text messaging services for business communications, service notifications, and promotional content. Consent is not a condition of purchase.
            </p>

            <h3>1. SMS Consent Communication</h3>
            <p>
              Information (Phone Numbers) obtained as part of the SMS consent process will not be shared with third parties for marketing purposes.
            </p>

            <h3>2. Types of SMS Communications</h3>
            <p>
              If consent has been given to receive text messages from TMH Global LLC, messages may be received related to the following:
            </p>
            <ul>
              <li>Appointment reminders</li>
              <li>Follow-up messages</li>
            </ul>
            <p>
              <strong>Example:</strong> Thank you for reaching out to TMH Global LLC. We've received your inquiry and are working on a solution. Our team will update you within 24-48 hours. For any further questions, feel free to reply or contact us at (703) 829-7277.
            </p>

            <h3>3. Message Frequency</h3>
            <p>
              Message frequency may vary depending on the type of communication. For example, up to 10 SMS messages per week may be received related to appointments/billing, etc.
            </p>

            <h3>4. Potential Fees for SMS Messaging</h3>
            <p>
              Standard message and data rates may apply, depending on the carrier's pricing plan. These fees may vary if the message is sent domestically or internationally.
            </p>

            <h3>5. Opt-In Method</h3>
            <p>
              Opt-in to receive SMS messages from TMH Global LLC can be done in the following ways:
            </p>
            <ul>
              <li>Filling out a form on our website</li>
            </ul>

            <h3>6. Opt-Out Method</h3>
            <p>
              Opting out of receiving SMS messages can be done at any time by replying "STOP" to any SMS message received. Alternatively, direct contact can be made to request removal from the messaging list.
            </p>

            <h3>7. Help</h3>
            <p>
              For any issues, reply with the keyword HELP. Alternatively, help can be obtained directly from us at (703) 829-7277 or support@tmhglobal.com.
            </p>
            <p>
              <strong>Additional Options:</strong> If SMS messages are not desired, the SMS consent box on forms can be left unchecked.
            </p>

            <h3>8. Standard Messaging Disclosures</h3>
            <ul>
              <li>Message and data rates may apply</li>
              <li>Opt out at any time by texting "STOP"</li>
              <li>For assistance, text "HELP" or visit our Privacy Policy and Terms and Conditions pages</li>
              <li>Message frequency may vary</li>
            </ul>

            <h2>User Responsibilities</h2>
            <p>You agree to:</p>
            <ul>
              <li>Provide accurate and complete information</li>
              <li>Maintain the confidentiality of your account credentials</li>
              <li>Use our services in compliance with applicable laws</li>
              <li>Not misuse or attempt to disrupt our services</li>
            </ul>

            <h2>Privacy and Data Protection</h2>
            <p>
              Your privacy is important to us. Please review our Privacy Policy to understand how we collect, use, and protect your information.
            </p>

            <h2>Limitation of Liability</h2>
            <p>
              TMH Global LLC provides services on an "as is" basis. We strive for accuracy but cannot guarantee that our services will be error-free or uninterrupted.
            </p>

            <h2>Modifications</h2>
            <p>
              We reserve the right to modify these terms at any time. Changes will be posted on this page with an updated date.
            </p>

            <h2>Contact Information</h2>
            <p>For questions about these Terms of Service:</p>
            <ul>
              <li>Email: support@tmhglobal.com</li>
              <li>Phone: (703) 829-7277</li>
              <li>Business: TMH Global LLC</li>
            </ul>
          </CardContent>
        </Card>
      </div>
    </div>
  );
}