import { Card, CardContent, CardHeader, CardTitle } from "@/components/ui/card";

export default function Privacy() {
  return (
    <div className="py-20">
      <div className="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
        <Card>
          <CardHeader>
            <CardTitle className="text-3xl font-bold text-center">Privacy Policy</CardTitle>
            <p className="text-center text-muted-foreground">Last updated: {new Date().toLocaleDateString()}</p>
          </CardHeader>
          <CardContent className="prose prose-slate max-w-none dark:prose-invert">
            <h2>Company Information</h2>
            <p>
              <strong>TMH Global LLC</strong><br />
              Professional Accounting and Business Services<br />
              Email: support@tmhglobal.com<br />
              Phone: (703) 829-7277<br />
              Website: {window.location.origin}
            </p>

            <h2>Information We Collect</h2>
            <p>We collect information you provide directly to us, such as when you:</p>
            <ul>
              <li>Fill out contact forms or consultation requests</li>
              <li>Subscribe to our services or communications</li>
              <li>Opt in to receive SMS/text messages</li>
              <li>Use our client portal or training materials</li>
            </ul>

            <h2>SMS/MMS Messaging Policy</h2>
            <p>
              <strong>Consent:</strong> By providing your phone number and opting in, you consent to receive SMS/MMS messages from TMH Global LLC for business communications, service updates, and promotional content.
            </p>
            <p>
              <strong>Message Frequency:</strong> Message frequency varies based on your preferences and business needs.
            </p>
            <p>
              <strong>Standard Rates:</strong> Message and data rates may apply. Carriers are not liable for delayed or undelivered messages.
            </p>
            <p>
              <strong>Opt-Out Instructions:</strong> You may opt out at any time by replying STOP to any text message from us. After opting out, you will receive a confirmation message.
            </p>
            <p>
              <strong>Help:</strong> Reply HELP for assistance or contact us at support@tmhglobal.com or (703) 829-7277.
            </p>
            <p>
              <strong>Supported Carriers:</strong> This service works with major U.S. carriers including Verizon, AT&T, T-Mobile, Sprint, and others.
            </p>

            <h2>How We Use Your Information</h2>
            <p>We use the information we collect to:</p>
            <ul>
              <li>Provide and improve our professional services</li>
              <li>Communicate with you about your account and services</li>
              <li>Send you business updates and compliance alerts</li>
              <li>Provide customer support</li>
              <li>Send SMS notifications (with your consent)</li>
            </ul>

            <h2>Information Sharing</h2>
            <p>We do not sell, trade, or rent your personal information to third parties. We may provide information:</p>
            <ul>
              <li>With service providers who assist us in business operations</li>
              <li>When required by law or to protect our rights</li>
              <li>With your consent</li>
            </ul>

            <h2>Data Security</h2>
            <p>We implement appropriate security measures to protect your personal information against unauthorized access, disclosure, or destruction.</p>

            <h2>Contact Us</h2>
            <p>If you have questions about this Privacy Policy, please contact us:</p>
            <ul>
              <li>Email: support@tmhglobal.com</li>
              <li>Phone: (703) 829-7277</li>
              <li>Mail: TMH Global LLC</li>
            </ul>
          </CardContent>
        </Card>
      </div>
    </div>
  );
}