import { useEffect, useState } from "react";
import { useLocation } from "wouter";
import { SUBSCRIPTION_TIERS } from "@shared/subscription-tiers";
import SquareCheckout from "@/components/SquareCheckout";
import { Card, CardContent } from "@/components/ui/card";
import { AlertCircle } from "lucide-react";
import { Alert, AlertDescription } from "@/components/ui/alert";

export default function Checkout() {
  const [location, navigate] = useLocation();
  const [selectedTier, setSelectedTier] = useState<any>(null);

  useEffect(() => {
    // Parse URL parameters to get selected plan
    const urlParams = new URLSearchParams(window.location.search);
    const planId = urlParams.get('plan');
    
    if (planId) {
      const tier = SUBSCRIPTION_TIERS.find(t => t.id === planId);
      if (tier) {
        setSelectedTier(tier);
      } else {
        navigate('/pricing');
      }
    } else {
      navigate('/pricing');
    }
  }, [navigate]);

  const handlePaymentSuccess = () => {
    navigate('/premium');
  };

  const handlePaymentCancel = () => {
    navigate('/pricing');
  };

  if (!selectedTier) {
    return (
      <div className="min-h-screen bg-gray-50 flex items-center justify-center">
        <Card className="max-w-md">
          <CardContent className="p-6">
            <Alert>
              <AlertCircle className="h-4 w-4" />
              <AlertDescription>
                Loading checkout information...
              </AlertDescription>
            </Alert>
          </CardContent>
        </Card>
      </div>
    );
  }

  return (
    <SquareCheckout
      amount={selectedTier.price}
      planName={selectedTier.name}
      planId={selectedTier.id}
      onSuccess={handlePaymentSuccess}
      onCancel={handlePaymentCancel}
    />
  );
}