import { Card, CardContent, CardDescription, CardHeader, CardTitle } from "@/components/ui/card";
import { Button } from "@/components/ui/button";
import { ArrowRight, LucideIcon } from "lucide-react";

interface ServiceCardProps {
  icon: LucideIcon;
  title: string;
  description: string;
  link: string;
  index: number;
}

export default function ServiceCard({ icon: Icon, title, description, link, index }: ServiceCardProps) {
  const handleLearnMore = () => {
    // Navigate to the service link
    window.location.href = link;
  };

  return (
    <Card 
      className="service-card h-full flex flex-col"
      style={{ animationDelay: `${index * 100}ms` }}
    >
      <CardHeader className="flex-grow">
        <div className="w-12 h-12 bg-primary/10 rounded-lg flex items-center justify-center mb-4">
          <Icon className="h-6 w-6 text-primary" aria-hidden="true" />
        </div>
        <CardTitle className="text-xl font-semibold text-foreground mb-2">
          {title}
        </CardTitle>
        <CardDescription className="text-muted-foreground leading-relaxed">
          {description}
        </CardDescription>
      </CardHeader>
      <CardContent className="pt-0">
        <Button 
          onClick={handleLearnMore}
          variant="ghost"
          className="p-0 h-auto text-primary hover:text-primary/80 font-medium group focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-ring focus-visible:ring-offset-2 rounded"
          data-testid={`button-learn-more-${title.toLowerCase().replace(/\s+/g, '-')}`}
          aria-label={`Learn more about ${title}`}
        >
          Learn More 
          <ArrowRight className="ml-1 h-4 w-4 transition-transform group-hover:translate-x-1" aria-hidden="true" />
        </Button>
      </CardContent>
    </Card>
  );
}
