import { useQuery } from "@tanstack/react-query";
import { useLocation } from "wouter";
import { useEffect } from "react";

interface ProtectedRouteProps {
  children: React.ReactNode;
}

export function ProtectedRoute({ children }: ProtectedRouteProps) {
  const [location, setLocation] = useLocation();
  
  const { data: authStatus, isLoading } = useQuery<{ isAuthenticated: boolean }>({
    queryKey: ["/api/auth/check"],
    retry: false,
  });

  useEffect(() => {
    if (!isLoading && !authStatus?.isAuthenticated) {
      // Save the current location to redirect back after login
      sessionStorage.setItem('redirectAfterLogin', location);
      setLocation("/admin/login");
    }
  }, [authStatus, isLoading, setLocation, location]);

  if (isLoading) {
    return (
      <div className="min-h-screen flex items-center justify-center">
        <div className="text-center">
          <div className="animate-spin rounded-full h-12 w-12 border-b-2 border-primary mx-auto"></div>
          <p className="mt-4 text-muted-foreground">Loading...</p>
        </div>
      </div>
    );
  }

  if (!authStatus?.isAuthenticated) {
    return null;
  }

  return <>{children}</>;
}
