import { Link } from "wouter";
import { Facebook, Linkedin, Twitter } from "lucide-react";

const footerSections = {
  services: [
    { label: "Bookkeeping", href: "/services#bookkeeping" },
    { label: "HR Services", href: "/services#hr" },
    { label: "CFO Services", href: "/services#cfo" },
    { label: "Auditing", href: "/services#auditing" },
    { label: "Business Development", href: "/services#business-development" },
    { label: "Tax Preparation", href: "/services#tax" }
  ],
  government: [
    { label: "S.A.M. Registration", href: "/government-contracting" },
    { label: "VPAT Documentation", href: "/government-contracting" },
    { label: "Compliance Support", href: "/government-contracting" },
    { label: "Section 508 Guidance", href: "/government-contracting" },
    { label: "WCAG 2.1 AA Support", href: "/government-contracting" }
  ],
  resources: [
    { label: "Client Portal", href: "/client-portal" },
    { label: "Training Videos", href: "/client-portal" },
    { label: "Document Library", href: "/client-portal" },
    { label: "Compliance Guides", href: "/government-contracting" },
    { label: "Contact Support", href: "/contact" }
  ]
};

const socialLinks = [
  // Social media links will be added when accounts are created
  // For SMS TCR compliance, only including working contact methods
];

export default function Footer() {
  return (
    <footer className="bg-secondary text-secondary-foreground py-16" role="contentinfo">
      <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div className="grid md:grid-cols-2 lg:grid-cols-4 gap-8">
          {/* Company Info */}
          <div>
            <h3 className="text-xl font-bold mb-4">TMH Global LLC</h3>
            <p className="text-secondary-foreground/80 mb-6">
              Professional accounting and government contracting expertise 
              with full accessibility compliance.
            </p>
            <div className="space-y-2">
              <p className="text-sm font-semibold">Contact Us:</p>
              <p className="text-sm">Phone: (703) 829-7277</p>
              <p className="text-sm">Email: support@tmhglobal.com</p>
            </div>
          </div>
          
          {/* Services */}
          <div>
            <h4 className="text-lg font-semibold mb-4">Services</h4>
            <ul className="space-y-2 text-secondary-foreground/80">
              {footerSections.services.map((item) => (
                <li key={item.label}>
                  <Link 
                    href={item.href}
                    className="hover:text-secondary-foreground transition-colors focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-ring focus-visible:ring-offset-2 focus-visible:ring-offset-secondary rounded"
                    data-testid={`footer-link-${item.label.toLowerCase().replace(/\s+/g, '-')}`}
                  >
                    {item.label}
                  </Link>
                </li>
              ))}
            </ul>
          </div>
          
          {/* Government Contracting */}
          <div>
            <h4 className="text-lg font-semibold mb-4">Government Contracting</h4>
            <ul className="space-y-2 text-secondary-foreground/80">
              {footerSections.government.map((item) => (
                <li key={item.label}>
                  <Link 
                    href={item.href}
                    className="hover:text-secondary-foreground transition-colors focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-ring focus-visible:ring-offset-2 focus-visible:ring-offset-secondary rounded"
                    data-testid={`footer-link-${item.label.toLowerCase().replace(/\s+/g, '-')}`}
                  >
                    {item.label}
                  </Link>
                </li>
              ))}
            </ul>
          </div>
          
          {/* Resources */}
          <div>
            <h4 className="text-lg font-semibold mb-4">Resources</h4>
            <ul className="space-y-2 text-secondary-foreground/80">
              {footerSections.resources.map((item) => (
                <li key={item.label}>
                  <Link 
                    href={item.href}
                    className="hover:text-secondary-foreground transition-colors focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-ring focus-visible:ring-offset-2 focus-visible:ring-offset-secondary rounded"
                    data-testid={`footer-link-${item.label.toLowerCase().replace(/\s+/g, '-')}`}
                  >
                    {item.label}
                  </Link>
                </li>
              ))}
            </ul>
          </div>
        </div>
        
        {/* Footer Bottom */}
        <div className="border-t border-secondary-foreground/20 mt-12 pt-8">
          <div className="flex flex-col md:flex-row justify-between items-center">
            <p className="text-secondary-foreground/80 text-sm">
              © 2025 TMH Global LLC. All rights reserved.
            </p>
            <div className="flex space-x-6 mt-4 md:mt-0">
              <Link 
                href="/privacy" 
                className="text-secondary-foreground/80 hover:text-secondary-foreground text-sm transition-colors focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-ring focus-visible:ring-offset-2 focus-visible:ring-offset-secondary rounded"
                data-testid="footer-link-privacy"
              >
                Privacy Policy
              </Link>
              <Link 
                href="/terms" 
                className="text-secondary-foreground/80 hover:text-secondary-foreground text-sm transition-colors focus-visible:outline-none focus-visible:ring-2 focus-visible:ring-ring focus-visible:ring-offset-2 focus-visible:ring-offset-secondary rounded"
                data-testid="footer-link-terms"
              >
                Terms of Service
              </Link>
            </div>
          </div>
          
          {/* Compliance Certifications */}
          <div className="mt-6 text-center">
            <p className="text-secondary-foreground/60 text-xs">
              WCAG 2.1 AA Compliant | Section 508 Certified | VPAT Documentation Available
            </p>
          </div>
        </div>
      </div>
    </footer>
  );
}
