import { Badge } from "@/components/ui/badge";
import { Shield, CheckCircle, Award, FileCheck } from "lucide-react";

const complianceBadges = [
  {
    icon: CheckCircle,
    text: "WCAG 2.1 AA Compliant",
    variant: "secondary" as const,
    testId: "badge-wcag-compliant"
  },
  {
    icon: Shield,
    text: "Section 508 Certified",
    variant: "secondary" as const,
    testId: "badge-section-508"
  },
  {
    icon: FileCheck,
    text: "VPAT Documentation Ready",
    variant: "secondary" as const,
    testId: "badge-vpat-ready"
  }
];

export default function ComplianceBadges() {
  return (
    <div className="flex flex-wrap gap-4" role="group" aria-label="Compliance certifications">
      {complianceBadges.map((badge, index) => (
        <div
          key={badge.testId}
          className="flex items-center bg-card border border-border rounded-lg px-4 py-2 hover:shadow-sm transition-shadow"
          data-testid={badge.testId}
        >
          <badge.icon 
            className="h-4 w-4 text-accent mr-2 flex-shrink-0" 
            aria-hidden="true" 
          />
          <span className="text-sm font-medium text-foreground">
            {badge.text}
          </span>
        </div>
      ))}
    </div>
  );
}
