import { Switch, Route } from "wouter";
import { queryClient } from "./lib/queryClient";
import { QueryClientProvider } from "@tanstack/react-query";
import { Toaster } from "@/components/ui/toaster";
import { TooltipProvider } from "@/components/ui/tooltip";
import NotFound from "@/pages/not-found";
import Home from "@/pages/home";
import Services from "@/pages/services";
import GovernmentContracting from "@/pages/government-contracting";
import ClientPortal from "@/pages/client-portal";
import Community from "@/pages/community";
import Monitoring from "@/pages/monitoring";
import ComplianceMonitoring from "@/pages/compliance-monitoring";
import Premium from "@/pages/premium";
import Pricing from "@/pages/pricing";
import Training from "@/pages/training";
import LiveTraining from "@/pages/live-training";
import Consultation from "@/pages/consultation";
import Contact from "@/pages/contact";
import Privacy from "@/pages/privacy";
import Terms from "@/pages/terms";
import Checkout from "@/pages/checkout";
import SMSCampaigns from "@/pages/sms-campaigns";
import Settings from "@/pages/settings";
import AdminVideos from "@/pages/admin-videos";
import AdminLogin from "@/pages/admin-login";
import Navigation from "@/components/navigation";
import Footer from "@/components/footer";
import SkipLink from "@/components/accessibility/skip-link";
import { ProtectedRoute } from "@/components/protected-route";

function Router() {
  return (
    <Switch>
      <Route path="/" component={Home} />
      <Route path="/services" component={Services} />
      <Route path="/government-contracting" component={GovernmentContracting} />
      <Route path="/client-portal" component={ClientPortal} />
      <Route path="/community" component={Community} />
      <Route path="/monitoring" component={Monitoring} />
      <Route path="/compliance-monitoring" component={ComplianceMonitoring} />
      <Route path="/premium" component={Premium} />
      <Route path="/pricing" component={Pricing} />
      <Route path="/training" component={Training} />
      <Route path="/live-training" component={LiveTraining} />
      <Route path="/consultation" component={Consultation} />
      <Route path="/consultations" component={Consultation} />
      <Route path="/contact" component={Contact} />
      <Route path="/privacy" component={Privacy} />
      <Route path="/terms" component={Terms} />
      <Route path="/checkout" component={Checkout} />
      <Route path="/admin/login" component={AdminLogin} />
      <Route path="/sms-campaigns">
        <ProtectedRoute>
          <SMSCampaigns />
        </ProtectedRoute>
      </Route>
      <Route path="/settings">
        <ProtectedRoute>
          <Settings />
        </ProtectedRoute>
      </Route>
      <Route path="/admin/videos">
        <ProtectedRoute>
          <AdminVideos />
        </ProtectedRoute>
      </Route>
      <Route component={NotFound} />
    </Switch>
  );
}

function App() {
  return (
    <QueryClientProvider client={queryClient}>
      <TooltipProvider>
        <div className="min-h-screen bg-background text-foreground">
          <SkipLink />
          <Navigation />
          <main id="main-content">
            <Router />
          </main>
          <Footer />
          <Toaster />
        </div>
      </TooltipProvider>
    </QueryClientProvider>
  );
}

export default App;
