# Adding Your Logo and Images

## Quick Start Guide

### 1. Add Your Logo
- Place your logo file in `attached_assets/images/`
- Recommended name: `logo.png` or `logo.svg` 
- Recommended size: 200x80 pixels (or similar aspect ratio)
- Supported formats: PNG, SVG, JPG, WEBP

### 2. Add Additional Images
- Create folders for different image types:
  - `attached_assets/images/team/` - Staff photos
  - `attached_assets/images/office/` - Office photos  
  - `attached_assets/images/services/` - Service-related images
  - `attached_assets/images/testimonials/` - Client photos (with permission)

### 3. How Images Work in Your Website
After adding images to the `attached_assets` folder, you reference them in code like this:

```javascript
import logoImage from "@assets/images/logo.png"
import teamPhoto from "@assets/images/team/john-doe.jpg"

// Then use in your components:
<img src={logoImage} alt="TMH Global LLC Logo" />
<img src={teamPhoto} alt="John Doe, Senior Accountant" />
```

### 4. Current Logo Location
Your logo will appear in the top-left corner of every page, replacing the current text "TMH Global LLC".

### 5. Best Practices
- Use descriptive filenames: `ceo-photo.jpg` not `img001.jpg`
- Optimize images for web (under 1MB each)
- Always include alt text for accessibility
- Use consistent image sizes for team photos/staff

## Supported Image Formats
- PNG (best for logos with transparency)
- SVG (best for simple logos, scales perfectly)
- JPG (best for photos)
- WEBP (modern format, smaller file sizes)